(() => {
    'use strict';

    // 装備画面で特徴表示用のウインドウの作成
    function Window_EquipData() {
        this.initialize(...arguments);
    }

    Window_EquipData.prototype = Object.create(Window_Help.prototype);
    Window_EquipData.prototype.constructor = Window_EquipData;

    // コンストラクタ
    Window_EquipData.prototype.initialize = function(rect) {
        Window_Help.prototype.initialize.call(this, rect);
        this._item = null;
    };

    // 描画するアイテム（特徴を持った武器）のセット処理
    Window_EquipData.prototype.setItem = function(item) {
        this._item = item;
        this.refresh();
    };

    // ウインドウの再描画
    Window_EquipData.prototype.refresh = function() {
        this.contents.clear();
        if (!this._item) return;

        let rowCount = 0;

        // 項目名描画
        const rect1 = this.itemRect(rowCount);
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("基礎ステータス", rect1.x, rect1.y, rect1.width, "left");
        this.resetTextColor();

        rowCount += 2;

        // 装備ステータスの描画処理
        this.drawEquipStatus("HP", this._item.hp, rowCount);
        this.drawEquipStatus("攻撃力", this._item.atk, rowCount + 1);

        rowCount += 4;

         // 項目名描画
        const rect2 = this.itemRect(rowCount);
        this.changeTextColor(ColorManager.systemColor());
        this.drawText("アビリティ", rect2.x, rect2.y, rect2.width, "left");
        this.resetTextColor();

        rowCount += 2;

        // 特徴の描画処理
        const traits = this._item.traits ?? [];
        for (let i = 0; i < traits.length; i++) {
            this.drawTraitItem(traits[i], i + rowCount);
        }
    };

     // 武器の攻撃力とHPの描画処理
    Window_EquipData.prototype.drawEquipStatus = function(title, value, index) {
        // 描画用の矩形取得
        const rect = this.itemRect(index);

        const nameWidth = Math.floor(rect.width * 0.65);
        const valueWidth = rect.width - nameWidth;

        // 名前（左）
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(title, rect.x, rect.y, nameWidth, "left");

        // 数値（右）
        this.resetTextColor();
        this.drawText(value, rect.x + nameWidth, rect.y, valueWidth, "right");
    };

    // 特徴の描画処理
    Window_EquipData.prototype.drawTraitItem = function(item, index) {
        // 描画用の矩形取得
        const rect = this.itemRect(index);

        const nameWidth = Math.floor(rect.width * 0.65);
        const valueWidth = rect.width - nameWidth;

        // 名前（左）
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(item.name, rect.x, rect.y, nameWidth, "left");

        // 数値（右）
        this.resetTextColor();
        this.drawText("＋" + item.value + item.suffix, rect.x + nameWidth, rect.y, valueWidth, "right");
    };

    // 描画範囲の矩形取得処理
    Window_EquipData.prototype.itemRect = function(index) {
        const itemWidth = Math.floor(this.innerWidth / 2);
        const itemHeight = this.itemHeight();
        const colSpacing = 16;
        const rowSpacing = 4;
        const col = index % 2;
        const row = Math.floor(index / 2);
        const x = col * itemWidth + colSpacing / 2;
        const y = row * itemHeight + rowSpacing / 2;
        const width = itemWidth - colSpacing;
        const height = itemHeight - rowSpacing;
        return new Rectangle(x, y, width, height);
    };



    // 装備画面で使用するステータスのマップの取得処理
    Window_EquipStatus.prototype.getParamMap = function() {
        const EXT_PARAMS = {
            mhp: {
                name: "HP",
                get: actor => actor.mhp,
                suffix: ""
            },
            atk: {
                name: "攻撃力",
                get: actor => actor.atk,
                suffix: ""
            },
            hcp: {
                name: "ヒット＋",
                get: actor => actor.traitsHitCountPlus(),
                suffix: "％"
            },
            mla: {
                name: "連続攻撃",
                get: actor => actor.traitsMultiAttack(),
                suffix: "％"
            },
            rau: {
                name: "レアリティ＋",
                get: actor => actor.traitsRarityUp(),
                suffix: "％"
            },
            las: {
                name: "背水",
                get: actor => actor.traitsLastStand(),
                suffix: "％"
            },
            vig: {
                name: "旺盛",
                get: actor => actor.traitsVigor(),
                suffix: "％"
            },
            uny: {
                name: "不屈",
                get: actor => actor.traitsUnyielding(),
                suffix: "％"
            },
            for: {
                name: "盤石",
                get: actor => actor.traitsFortitude(),
                suffix: "％"
            },
            cri: {
                name: "会心＋",
                get: actor => actor.traitsCriticalPlus(),
                suffix: "％"
            },
            scr: {
                name: "超会心",
                get: actor => actor.traitsSuperCritical(),
                suffix: "％"
            },
            dcb: {
                name: "ダメ上限突破",
                get: actor => actor.traitsDamageCapBreak(),
                suffix: "％"
            },
            cnt: {
                name: "カウンター",
                get: actor => actor.traitsCounter(),
                suffix: "％"
            },
            hrg: {
                name: "HP再生率",
                get: actor => actor.traitsHpRegen(),
                suffix: "％"
            }
        };

        return EXT_PARAMS;
    };

    // 再描画処理
    Window_EquipStatus.prototype.refresh = function() {
        this.contents.clear();
        if (this._actor) {
            const nameRect = this.itemLineRect(0);
            this.drawActorName(this._actor, nameRect.x, 0, nameRect.width);
            // アクターの顔はいらないのでコメントアウト
            //this.drawActorFace(this._actor, nameRect.x, nameRect.height);
            this.drawAllParams();
        }
    };

    // パラメータの描画処理
    Window_EquipStatus.prototype.drawAllParams = function() {
        let index = 0;
        const EXT_PARAMS = this.getParamMap();

        // アクターとテンプアクターがセットされていない場合は処理しない
        if (this._actor != null){
            for (const key in EXT_PARAMS) {
                const p = EXT_PARAMS[key];
                const nowValue = p.get(this._actor);
                let newValue = 0;
                
                // 一時アクターがいる場合
                if (this._tempActor != null){
                    newValue = p.get(this._tempActor);
                }
                // 一時アクターがいない場合
                else {
                    newValue = p.get(this._actor);
                }

                // 描画処理
                const x = this.itemPadding();
                const y = this.paramY(index);
                this.exDrawItem(x, y, p.name, nowValue, newValue, p.suffix);
                index++;
            }
        }
    };

    // 項目の描画処理（別途作成）
    Window_EquipStatus.prototype.exDrawItem = function(x, y, name, nowValue, newValue, suffix) {
        this.exDrawParamName(x, y, name);
        this.exDrawParam(x, y, nowValue, newValue, suffix);
    };

    // パラメータ名の描画処理（別途作成）
    Window_EquipStatus.prototype.exDrawParamName = function(x, y, name) {
        const width = this.contentsWidth() - this.itemPadding() * 2;
        this.changeTextColor(ColorManager.systemColor());
        this.drawText(name, x, y, width);
    };

    // パラメータの描画処理（別途作成）
    Window_EquipStatus.prototype.exDrawParam = function(x, y, nowValue, newValue, suffix) {
        const width = this.contentsWidth() - this.itemPadding() * 2;
        const diffvalue = newValue - nowValue;
        this.changeTextColor(ColorManager.paramchangeTextColor(diffvalue));
        this.drawText((Math.floor(newValue * 100) / 100) + suffix, x, y, width, "right");
    };

    // パラメータ描画の開始Y座標
    Window_EquipStatus.prototype.paramY = function(index) {
        return this.lineHeight() * (index + 1);
    };

    // 最強装備がない分カラム数を減らす
    Window_EquipCommand.prototype.maxCols = function() {
        return 2;
    };

    // 最強装備を外す
    Window_EquipCommand.prototype.makeCommandList = function() {
        this.addCommand(TextManager.equip2, "equip");
        this.addCommand(TextManager.clear, "clear");
    };

    // 装備選択ウインドウのカラム数を増やして縦を短く
    Window_EquipSlot.prototype.maxCols = function() {
        return 2;
    };

    // 装備選択ウインドウの高さ指定
    Window_EquipSlot.prototype.windowHeight = function() {
        return this.fittingHeight(5);
    };

    // 装備アイテム選択ウインドウのカラム数の指定
    Window_EquipItem.prototype.maxCols = function() {
        return 2;
    };

    // ヘルプウインドウの作成処理
    Scene_Equip.prototype.createHelpWindow = function() {
        const rect = this.helpWindowRect();
        this._helpWindow = new Window_EquipData(rect);
        this.addWindow(this._helpWindow);
    };

    // ヘルプウインドウの矩形取得処理
    Scene_Equip.prototype.helpWindowRect = function() {
        const slotRect = this.slotWindowRect();
        const wx = this.statusWidth();
        const wy = slotRect.y + slotRect.height;
        const ww = Graphics.boxWidth - this.statusWidth();
        const wh = Graphics.boxHeight - wy;
        return new Rectangle(wx, wy, ww, wh);
    };

    // 装備選択ウインドウの矩形取得処理
    Scene_Equip.prototype.slotWindowRect = function() {
        const commandWindowRect = this.commandWindowRect();
        const wx = this.statusWidth();
        const wy = commandWindowRect.y + commandWindowRect.height;
        const ww = Graphics.boxWidth - this.statusWidth();
        const wh = this.calcWindowHeight(5, true);
        return new Rectangle(wx, wy, ww, wh);
    };

    // 装備画面のステータスウインドウの矩形取得処理
    Scene_Equip.prototype.statusWindowRect = function() {
        const commandRect = this.commandWindowRect();
        const slotRect = this.slotWindowRect();
        const wx = 0;
        const wy = this.mainAreaTop();
        const ww = this.statusWidth();
        const wh = Graphics.boxHeight - wy;
        return new Rectangle(wx, wy, ww, wh);
    };

})();